------------------------------------------------------------------------------------------------------------------------------------
function createArmyWayDefenders()

	troopsDefenders = {
        Entities.CU_Evil_LeaderBearman1,
        Entities.CU_Evil_LeaderSkirmisher1,
    	}

	armyWayDefenders1 = {}
    createArmy(2,4,armyWayDefenders1,8,"armyWay1",VERYHIGH_EXPERIENCE,troopsDefenders)

    armyWayDefenders2 = {}
    createArmy(2,5,armyWayDefenders2,8,"armyWay2",VERYHIGH_EXPERIENCE,troopsDefenders)

    armyCamp1 = {}
    createArmy(2,6,armyCamp1,8,"armyCamp1",VERYHIGH_EXPERIENCE,troopsDefenders)
	
	CreateArmySouthPath()

    StartSimpleJob("controlArmyWayDefenders")

    end
------------------------------------------------------------------------------------------------------------------------------------
function controlArmyWayDefenders()

    if IsDead(armyWayDefenders1) == false then
        simpleDefendBehaviour(armyWayDefenders1)
        end

    if IsDead(armyWayDefenders2) == false then
        simpleDefendBehaviour(armyWayDefenders2)
        end

    if IsDead(armyCamp1) == false then
        simpleDefendBehaviour(armyCamp1)
        end

    end
------------------------------------------------------------------------------------------------------------------------------------
function createArmyCamps()

    armyCamp2 = {}
	troopsDefenders = {
        Entities.CU_Evil_LeaderBearman1,
        Entities.CU_Evil_LeaderSkirmisher1,
    	}

    createArmy(2,7,armyCamp2,8,"armyCamp2",VERYHIGH_EXPERIENCE,troopsDefenders)

    armyCamp3 = {}
	
	thirdcamp = {}

    createArmy(2,8,armyCamp3,8,"armyCamp3",VERYHIGH_EXPERIENCE,troopsDefenders)

	createArmy(2,3,thirdcamp,8,"P2_Nephilim_Camp2_SpawnPoint",VERYHIGH_EXPERIENCE,troopsDefenders)

    StartSimpleJob("controlArmyCamps")
	
	for i = 1,6,1 do
		local defpos = GetPosition("Deftower"..(math.mod(i,3)+1))
		AI.Entity_CreateFormation(2, Entities.CU_Evil_LeaderSkirmisher1, nil, 16, defpos.X, defpos.Y, 0, 1, 3, 16)
	end
	
	patroulpos = {GetPosition("CUTSCENE_MOVE_END_DARIO"),
				GetPosition("CUTSCENE_MOVE_START_DARIO"),
				GetPosition("pat1"),
				GetPosition("pat2"),
				GetPosition("pat3"),
				GetPosition("pat4"),
				GetPosition("armyCamp2"),
				--GetPosition("armyCamp3"),
				GetPosition("pat5"),
				GetPosition("pat6"),
				GetPosition("pat7"),
				GetPosition("pat8"),
				GetPosition("pat9"),
					}
		PatroulUA1 = LazyUnlimitedArmy:New({
					Player = 2,
					Area = 2000,
					TransitAttackMove = true,
					Formation = UnlimitedArmy.Formations.Chaotic,
					AIActive = true,
					HiResJob = true,
					},
					6,
					21)
					
		PatroulUA2 = LazyUnlimitedArmy:New({
					Player = 2,
					Area = 2000,
					TransitAttackMove = true,
					Formation = UnlimitedArmy.Formations.Chaotic,
					AIActive = true,
					HiResJob = true,
					},
					7,
					21)
		PatroulUA1.SpawnCounter = 0
		PatroulUA1.SpawnerB = "PatroulTower1"
		PatroulUA2.SpawnCounter = 0
		PatroulUA2.SpawnerB = "PatroulTower2"
		PatroulUA1:AddCommandLuaFunc(PatroulArmy,true)
		PatroulUA2:AddCommandLuaFunc(PatroulArmy,true)
	
	WinterAttack = LazyUnlimitedArmy:New({
			Player = 2,
			Area = 2800,
			TransitAttackMove = true,
			Formation = UnlimitedArmy.Formations.Chaotic,
			AIActive = true,
			HiResJob = true,
			},
			8,
			21)
	WinterAttack.SpawnTable = {GetPosition("armyCamp2"),GetPosition("P2_Nephilim_Camp2_SpawnPoint"),GetPosition("armyCamp3")}
	WinterAttack.PosSpawn = false
	WinterAttack.SpawnCounter = 300
	WinterAttack:AddCommandLuaFunc(AttackIt,true)

    end
------------------------------------------------------------------------------------------------------------------------------------
function controlArmyCamps()

    if IsDead(armyCamp2) == false then
        simpleDefendBehaviour(armyCamp2)
	end
	if IsDead(armyCamp3) == false then
        simpleDefendBehaviour(armyCamp3)
	end
	if IsDead(thirdcamp) == false then
        simpleDefendBehaviour(thirdcamp)
	end
	
    end
	
function getspawnPos()
	local availableSpawns = {}
	local towersalive = false
	for j = 1,3,1 do
		for i = 1,6,1 do
			if IsAlive("gateTower"..j..i) then
				--towersalive = towersalive + 1
				towersalive = true
				break;
			end
		end
		if towersalive then
			--table.insert(availableSpawns,j)
			availableSpawns[j] = true
		end
	end
	local tablespot = 0
	for k,v in pairs(availableSpawns) do
			tablespot = k
			if math.random(1,2) == 1 then
				break;
			end
	end
	if tablespot == 0 then
		return 0
	end
	return tablespot
end

function AttackIt(self)
	self.UAPos = self:GetPosition()
	if self.SpawnCounter <= 0 then
		
		local Spawnpos = getspawnPos()
		if Spawnpos == 0 then
			return true
		end
		Spawnpos = self.SpawnTable[Spawnpos]
		local switch = true
		for i = 1,8,1 do
				self:CreateLeaderForArmy((switch and Entities.CU_Evil_LeaderBearman1) or Entities.CU_Evil_LeaderSkirmisher1, 16,Spawnpos,3)
				switch = not switch
		end
		local curPos = self:GetPosition()
		if self.UAPos == invalidPosition then
			self.UAPos = self:GetPosition()
		end
		self.SpawnCounter = 150
	else
		if Logic.GetWeatherState() == 3 or self:GetSize(false,false) <= 0 then
			self.SpawnCounter = self.SpawnCounter - 1
		end
	end
	
	
	if self:GetSize(false,false) > table.getn(self.LeaderTransit) then
		if UASimpleIdle(self) then
			return true, UnlimitedArmy.CreateCommandMove(GetPosition("player1"))
		end
	else
		if self.UAPos == invalidPosition then
			local Spawnpos = getspawnPos()
			if Spawnpos == 0 then
				return true
			end
			self.UAPos = self.SpawnTable[Spawnpos]
		end
		return true, UnlimitedArmy.CreateCommandDefend(self.UAPos,3200)
	end
	return false
end

--self.PosSpawn
--npcLabTarget
--player1

function UASimpleIdle(self)
	if self.Status ~= UnlimitedArmy.Status.Idle then
		return false
	end
	if GetDistance(self:GetPosition(), self.Target)>1000 then
		return false
	end
	for _,id in ipairs(self.Leaders) do
		if not UnlimitedArmy.IsLeaderIdle(id) then
			return false
		end
	end
	return true
end

function PatroulArmy(self)
	if self:GetSize(true,true) < 7 then
		if self.SpawnCounter <= 0 then
			local switch = true
			if IsDead(self.SpawnerB) then
				--self:Destroy()
				self.SpawnCounter = 100000000
				return true
			end
			local spawnerpos = GetPosition(self.SpawnerB)
			for i = 1,6-self:GetSize(true,true),1 do
					self:CreateLeaderForArmy((switch and Entities.CU_Evil_LeaderBearman1) or Entities.CU_Evil_LeaderSkirmisher1, 16,spawnerpos,3)
					switch = not switch
			end
			local trooptable = {ID = AI.Entity_CreateFormation(2, Entities.PU_LeaderHeavyCavalry2, nil, 0, spawnerpos.X, spawnerpos.Y, nil, nil, 3,0),PoisonCounter = 2}
			self:AddLeader(trooptable.ID)
			table.insert(giftreiter,trooptable)
			self.SpawnCounter = 300
		else
			self.SpawnCounter = self.SpawnCounter - 1
		end
	end
	if self:IsIdle() then
		return true, UnlimitedArmy.CreateCommandMove(patroulpos[GetRandom(1,table.getn(patroulpos))])
	end
end